#!/bin/sh

rootfsSizehex=$(/etc/fw_printenv rootfs_file_size | awk -F= '{print $2}')
rootfsSizenewhex=0x244DD2

kernelSizehex=$(/etc/fw_printenv kernel_file_size | awk -F= '{print $2}')
kernelSizenewhex=0x264FC3

rootfsSizeDec=$(printf "%d" $rootfsSizehex)
kernelSizeDec=$(printf "%d" $kernelSizehex)
rootfsSizenewDec=$(printf "%d" $rootfsSizenewhex)
kernelSizenewDec=$(printf "%d" $kernelSizenewhex)


# 比较两个变量的大小，并取较大的值
if [ "$rootfsSizenewDec" -gt "$rootfsSizeDec" ]; then
    maxRootfsSizeDec=$rootfsSizenewDec
else
    maxRootfsSizeDec=$rootfsSizeDec
fi

# 比较两个变量的大小，并取较大的值
if [ "$kernelSizenewDec" -gt "$kernelSizeDec" ]; then
    maxKernelsSizeDec=$kernelSizenewDec
else
    maxKernelsSizeDec=$kernelSizeDec
fi

#echo "rootfsSizenewDec=$rootfsSizenewDec  rootfsSizeDec=$rootfsSizeDec"
#echo "kernelSizenewDec=$kernelSizenewDec  kernelSizeDec=$kernelSizeDec"
#echo "maxRootfsSizeDec=$maxRootfsSizeDec  maxKernelsSizeDec=$maxKernelsSizeDec"

# 将 maxRootfsSize 转换为十六进制
maxRootfsSizeHex=$(printf "0x%X" $maxRootfsSizeDec)

# 将 maxKernelsSize 转换为十六进制
maxKernelsSizeHex=$(printf "0x%X" $maxKernelsSizeDec)

# 设置环境变量
/etc/fw_setenv rootfs_file_size $maxRootfsSizeHex
/etc/fw_setenv rootfs_file_size $maxRootfsSizeHex
/etc/fw_setenv initrd_size $maxRootfsSizeHex
/etc/fw_setenv initrd_size $maxRootfsSizeHex

/etc/fw_setenv kernel_file_size $maxKernelsSizeHex
/etc/fw_setenv kernel_file_size $maxKernelsSizeHex

# 打印结果
echo "Updated environment variables:"
echo "rootfsSizenewhex=$rootfsSizenewhex  rootfsSizehex=$rootfsSizehex"
echo "rootfs_file_size=$maxRootfsSizeHex"
echo "initrd_size=$maxRootfsSizeHex"
echo "kernelSizenewhex=$kernelSizenewhex  kernelSizehex=$kernelSizehex"
echo "kernel_file_size=$maxKernelsSizeHex"
