#!/bin/sh
cd /cache || exit
if [ -f /cache/pre_update.sh ] ; then
	/cache/pre_update.sh
fi
if [ -f arm_sigmastar.bin.gz ] ; then
	# ota_end.sh would deal with the upgrade result
	UPGRADE_COUNT_FILE=/cache/upgrade_count
	UPGRADE_COUNT=0
	if [ -e ${UPGRADE_COUNT_FILE} ];then
		UPGRADE_COUNT=$(cat ${UPGRADE_COUNT_FILE})
		echo "UPGRADE_COUNT:${UPGRADE_COUNT}"
		if [ "${UPGRADE_COUNT}" -ge 1 ];then
			nandtest -m /dev/mtd5
		fi
		if [ "${UPGRADE_COUNT}" -ge 5 ];then
			rm -f ${UPGRADE_COUNT_FILE}
			rm -f /cache/*.bin.gz
			sync
			/etc/reboot_to_normal.sh
			return 1
		fi
	fi
	echo "before UPGRADE_COUNT:${UPGRADE_COUNT}"
	UPGRADE_COUNT=$((UPGRADE_COUNT + 1))
	echo "after UPGRADE_COUNT:${UPGRADE_COUNT}"
	echo $UPGRADE_COUNT > ${UPGRADE_COUNT_FILE}
    /bin/otaunpack -x arm_sigmastar.bin.gz
	if [ $? -ne 0 ]; then
		echo "otaunpack failed, reboot to recovery!"
		reboot
	fi	
	
else
	echo "${BIN_NAME}-${VERSION}.bin.gz NOT exit! reboot ot narmal!"
	/etc/reboot_to_normal.sh
fi

exit 0
